<%@ taglib uri="http://java.sun.com/jstl/core" prefix="c" %>
<%@ taglib uri="/surjey" prefix="surjey" %>

<surjey:renderSurvey var="survey">

<form action="SubmitSurvey" method="post">
  <input type="hidden" name="surveyId" value="<c:out value="${survey.id}"/>" />

  <div class="survey">
    <div class="surveyName"><c:out value="${survey.name}"/></div>
    <div class="surveyDesc"><c:out value="${survey.description}"/></div>
    <div class="surveyContents">

      <surjey:renderSections use="survey" var="section">

      <div class="section">
        <div class="sectionName"><c:out value="${section.name}"/></div>
        <div class="sectionDesc"><c:out value="${section.description}"/></div>
        <div class="question">
          <ol>

            <surjey:renderQuestions use="section" var="question">

              <li>
                <div class="questionLabel">
                  <c:out value="${question.label}"/>
                </div>

                <div class="question">

                  <c:set var="qid" value="q${question.id}"/>
                  <c:set var="qsize" value="${question.displaySize}"/>
                  <c:set var="qtype" value="${question.questionType.name}"/>

                  <c:if test="${qtype == 'Select' || qtype == 'Select Multiple'}"
                        var="isSelect"/>

                  <c:choose>
                    <c:when test="${qtype == 'Select'}">

                      <select name="<c:out value="${qid}"/>"
                              size="<c:out value="${qsize}"/>">

                    </c:when>
                    <c:when test="${qtype == 'Select Multiple'}">

                      <select name="<c:out value="${qid}"/>"
                              size="<c:out value="${qsize}"/>"
                              multiple="multiple">

                    </c:when>
                    <c:when test="${qtype == 'Textbox'}">

                      <textarea name="<c:out value="${qid}"/>"
                                rows="<c:out value="${qrows}"/>"
                                cols="<c:out value="${qcols}"/>" /></textarea>

                    </c:when>
                    <c:when test="${qtype == 'Text'}">

                      <input type="text"
                             name="<c:out value="${qid}"/>"
                             size="<c:out value="${qsize}"/>" />

                    </c:when>
                  </c:choose>

                  <surjey:renderAnswers use="question" var="answer">

                    <c:choose>
                      <c:when test="${isSelect}">
                          <option value="<c:out value="${answer}"/>">
                            <c:out value="${answer}"/>
                          </option>
                      </c:when>
                      <c:when test="${qtype == 'Radio'}">
                        <div class="questionAnswer">
                          <input type="radio"
                                 name="<c:out value="${qid}"/>"
                                 value="<c:out value="${answer}"/>" />
                          <c:out value="${answer}"/><br />
                        </div>
                      </c:when>
                      <c:when test="${qtype == 'Check'}">
                        <div class="questionAnswer">
                          <input type="checkbox"
                                 name="<c:out value="${qid}"/>"
                                 value="<c:out value="${answer}"/>" />
                          <c:out value="${answer}"/><br />
                        </div>
                      </c:when>
                    </c:choose>

                  </surjey:renderAnswers>

                  <c:if test="${isSelect}"></select></c:if>

                </div>

              </li>

            </surjey:renderQuestions>

          </ol>
        </div>

      </div>

    </surjey:renderSections>
  </div>
  <input type="submit" value="Submit Survey" />
</form>

<form action="Main">
  <input type="submit" value="Cancel" />
</form>

</surjey:renderSurvey>

