<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>

<div class="viewTitle"><c:out value="${mode}"/> Survey</div>

<c:choose>
<c:when test="${mode == 'Create'}">
  <c:set var="submitAction" value="CreateSurvey"/>
  <c:set var="updateButtonLabel" value="Create"/>
  <c:set var="doneButtonLabel" value="Cancel"/>
</c:when>
<c:when test="${mode == 'Edit'}">
  <c:set var="submitAction" value="UpdateSurvey"/>
  <c:set var="updateButtonLabel" value="Save"/>
  <c:set var="doneButtonLabel" value="Back"/>
</c:when>
</c:choose>

<form action="<c:out value="${submitAction}"/>" method="post">
  <input type="hidden" name="surveyId" value="<c:out value="${survey.id}"/>" />
  <table class="masterTable">
    <tr>
      <th>Name:</th>
      <td><input type="text" name="name" value="<c:out value="${survey.name}"/>" /></td>
    </tr>
    <tr>
      <th>Description:</th>
      <td><textarea name="description" cols="40" rows="15"><c:out value="${survey.description}"/></textarea></td>
    </tr>
    <tr>
      <th></th>
      <td>
        <input type="submit" value="<c:out value="${updateButtonLabel}"/>" />
      </td>
    </tr>
  </table>
</form>

<c:if test="${mode == 'Edit'}">

<div class="detailTitle">Sections</div>

<table class="detailTable">
  <tr>
    <th>Num</th>
    <th>Name</th>
    <th>Description</th>
    <th></th>
  </tr>

  <c:forEach items="${survey.sections}" var="section">
    <form action="/" method="post">
      <input type="hidden" name="sectionId" value="<c:out value="${section.id}"/>" />
      <input type="hidden" name="surveyId" value="<c:out value="${survey.id}"/>" />
      <tr>
        <td><c:out value="${section.position}"/></td>
        <td><c:out value="${section.name}"/></td>
        <td><c:out value="${section.description}"/></td>
        <td>
          <input type="submit" value="Edit"           onclick="this.form.action='EditSection'; return true;" />
          <input type="submit" value="Delete"         onclick="this.form.action='DeleteSection'; return true;" />
          <!--
          <input type="submit" value="Move Up"        onclick="this.form.action='MoveSectionUp'; return true;" />
          <input type="submit" value="Move Down"      onclick="this.form.action='MoveSectionDn'; return true;" />
          -->
        </td>
      </tr>
    </form>
  </c:forEach>
  <form action="AddSection" method="post">
    <input type="hidden" name="surveyId" value="<c:out value="${survey.id}"/>" />
    <tr>
      <td colspan="5"><input type="submit" value="New Section" /></td>
    </tr>
  </form>
</table>

</c:if>

<form action="ListSurveys" method="post">
  <input type="submit" value="<c:out value="${doneButtonLabel}"/>" />
</form>
