<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>

<div class="viewTitle"><c:out value="${mode}"/> Section</div>

<c:choose>
<c:when test="${mode == 'Create'}">
  <c:set var="submitAction" value="CreateSection"/>
  <c:set var="updateButtonLabel" value="Create"/>
  <c:set var="doneButtonLabel" value="Cancel"/>
</c:when>
<c:when test="${mode == 'Edit'}">
  <c:set var="submitAction" value="UpdateSection"/>
  <c:set var="updateButtonLabel" value="Save"/>
  <c:set var="doneButtonLabel" value="Back"/>
</c:when>
</c:choose>

<form action="<c:out value="${submitAction}"/>" method="post">
  <input type="hidden" name="surveyId" value="<c:out value="${section.surveyId}"/>" />
  <input type="hidden" name="sectionId" value="<c:out value="${section.id}"/>" />
  <input type="hidden" name="position" value="<c:out value="${section.position}"/>" />
  <table class="masterTable">
    <tr>
      <th>Name:</th>
      <td><input type="text" name="name" value="<c:out value="${section.name}"/>" /></td>
    </tr>
    <tr>
      <th>Description:</th>
      <td><textarea name="description" cols="40" rows="15"><c:out value="${section.description}"/></textarea></td>
    </tr>
    <tr>
      <th></th>
      <td>
        <input type="submit" value="<c:out value="${updateButtonLabel}"/>" />
      </td>
    </tr>
  </table>
</form>

<c:if test="${mode == 'Edit'}">

<div class="detailTitle">Questions</div>

<table class="detailTable">
  <tr>
    <th>Num</th>
    <th>Label</th>
    <th>Type</th>
    <th>Answers</th>
    <th></th>
  </tr>

  <c:forEach items="${section.questions}" var="question">
    <form action="/" method="post">
      <input type="hidden" name="questionId" value="<c:out value="${question.id}"/>" />
      <input type="hidden" name="sectionId" value="<c:out value="${section.id}"/>" />
      <tr>
        <td><c:out value="${question.position}"/></td>
        <td><c:out value="${question.label}"/></td>
        <td><c:out value="${question.questionType.name}"/></td>
        <td><c:out value="${question.answerLabels}"/></td>
        <td>
          <input type="submit" value="Edit"      onclick="this.form.action='EditQuestion';   return true;" />
          <input type="submit" value="Delete"    onclick="this.form.action='DeleteQuestion'; return true;" />
          <!--
          <input type="submit" value="Move Up"   onclick="this.form.action='MoveQuestionUp'; return true;" />
          <input type="submit" value="Move Down" onclick="this.form.action='MoveQuestionDn'; return true;" />
          -->
        </td>
      </tr>
    </form>
  </c:forEach>
  <form action="AddQuestion" method="post">
    <input type="hidden" name="sectionId" value="<c:out value="${section.id}"/>" />
    <tr>
      <td colspan="5"><input type="submit" value="New Question" /></td>
    </tr>
  </form>
</table>

</c:if>

<form action="EditSurvey" method="post">
  <input type="hidden" name="surveyId" value="<c:out value="${section.surveyId}"/>" />
  <input type="submit" value="<c:out value="${doneButtonLabel}"/>" />
</form>

