<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>

<div class="viewTitle"><c:out value="${mode}"/> Question</div>

<c:choose>
<c:when test="${mode == 'Create'}">
  <c:set var="submitAction" value="CreateQuestion"/>
  <c:set var="updateButtonLabel" value="Create"/>
  <c:set var="doneButtonLabel" value="Cancel"/>
</c:when>
<c:when test="${mode == 'Edit'}">
  <c:set var="submitAction" value="UpdateQuestion"/>
  <c:set var="updateButtonLabel" value="Save"/>
  <c:set var="doneButtonLabel" value="Back"/>
</c:when>
</c:choose>

<form action="<c:out value="${submitAction}"/>" method="post">
  <input type="hidden" name="questionId" value="<c:out value="${question.id}"/>" />
  <input type="hidden" name="position" value="<c:out value="${question.position}"/>" />
  <input type="hidden" name="sectionId" value="<c:out value="${question.sectionId}"/>" />
  <table class="masterTable">
    <tr>
      <th>Label:</th>
      <td>
        <input type="text"
               name="label"
               value="<c:out value="${question.label}"/>"
               size="50" />
      </td>
    </tr>
    <tr>
      <th>Type:</th>
      <td>
        <select name="questionTypeId">
          <c:set var="qtid" value="${question.questionTypeId}"/>
          <c:forEach items="${types}" var="qt">
            <option value="<c:out value="${qt.id}"/>"
                <c:if test="${qt.id == qtid}">
                  <c:out value="selected=\"selected\""/>
                </c:if>
            >
              <c:out value="${qt.name}"/>: <c:out value="${qt.description}"/>
            </option>
          </c:forEach>
        </select>
      </td>
    </tr>
    <tr>
      <th>Answers:</th>
      <td>
        <input type="text"
               name="answerLabels"
               value="<c:out value="${question.answerLabels}"/>"
               size="50" />
      </td>
    </tr>
    <tr>
      <th>Size:</th>
      <td>
        <input type="text"
               name="displaySize"
               value="<c:out value="${question.displaySize}"/>"
               size="50" />
      </td>
    </tr>
    <tr>
      <th></th>
      <td>
        <input type="submit" value="<c:out value="${updateButtonLabel}"/>" />
      </td>
    </tr>
  </table>
</form>

<form action="EditSection" method="post">
  <input type="hidden" name="sectionId" value="<c:out value="${question.sectionId}"/>" />
  <input type="submit" value="<c:out value="${doneButtonLabel}"/>" />
</form>


