<?xml version="1.0"?>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
>

<xsl:output
  method="html"
  version="4.0"
  doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
  doctype-system="http://www.w3.org/TR/html4/loose.dtd"
  indent="yes"
/>

<!-- Include stylesheet with project-specific info -->
<xsl:include href="project.xsl"/>

<!-- <xsl:preserve-space elements="*"/> -->

<!-- String: Link back to top of page -->
<xsl:param name="top_link">
  <span class="top_link"><a href="#top">top of document</a></span>
</xsl:param>

<xsl:template match="doc">
  <html>
    <head>
      <title><xsl:value-of select="$project_name"/> - <xsl:value-of select="@title"/></title>
      <link href="{$doc_path}/{$stylesheet_loc}" rel="stylesheet" type="text/css" />
    </head>
    <body bgcolor="white">

      <table width="620" cellspacing="0" cellpadding="0"><tr><td>

        <!-- Project heading -->
        <div class="projectTitle">
          <div class="headingLeft">
            <a name="top"><xsl:value-of select="$project_name"/></a>
          </div>
          <div class="headingRight">
            <xsl:value-of select="$release_version"/>
          </div>
        </div>

        <!-- Document title -->
        <div class="documentTitle"><xsl:value-of select="@title"/></div>

        <!-- Document contents -->
        <xsl:apply-templates/>

        <!-- Copyright footer -->
        <div class="copyright"><xsl:value-of select="$copyright"/></div>
      </td></tr></table>
    </body>
  </html>
</xsl:template>

<!-- section: A section of the document -->
<!-- @id: A unique id for this section; used by table of contents -->
<!-- @title: A title to use as a heading for this section -->
<!-- @section_depth: The depth of this section (top-level = 0) -->
<!-- @contents: Any pre-defined section contents (e.g. see toc template) -->
<xsl:template match="section" name="section">
  <xsl:param name="id" select="@id"/>
  <xsl:param name="title" select="@title"/>
  <xsl:param name="section_depth" select="0"/>
  <xsl:param name="contents">
    <xsl:apply-templates select="*[name()!='section' and name()!='toc']"/>
  </xsl:param>

  <!-- Compute the appropriate heading level, given the depth -->
  <xsl:variable name="heading_level" select="$section_heading_level + $section_depth"/>
  <xsl:if test="$heading_level &gt; 6">
    <xsl:variable name="heading_level" select="6"/>
  </xsl:if>

  <!-- Insert the heading row -->
  <div class="sectionHeading">
    <div class="headingLeft">
      <span class="heading{$heading_level}"><a name="{$id}"><xsl:value-of select="$title"/></a></span>
    </div>
    <div class="headingRight">
      <xsl:if test="$section_depth = 0"><xsl:copy-of select="$top_link"/></xsl:if>
    </div>
  </div>

  <!-- Add all non-section/non-toc children -->
  <div class="sectionContents">
    <!-- Insert section contents -->
    <xsl:copy-of select="$contents"/>
  </div>

  <!-- Add all toc's and subsections -->
  <xsl:apply-templates select="section|toc">
    <!-- Increment the section depth with each recursion -->
    <xsl:with-param name="section_depth" select="$section_depth + 1"/>
  </xsl:apply-templates>

  <div class="sectionFooter">
  </div>

</xsl:template>

<!-- toc: Builds table of contents from the sibling section elements -->
<!-- @section_depth: The depth of this section (top-level = 0) -->
<xsl:template match="toc">
  <xsl:param name="section_depth" select="0"/>

  <xsl:variable name="list_type" select="substring($toc_list_types,($section_depth+1),1)"/>

  <xsl:call-template name="section">
    <xsl:with-param name="title">Contents</xsl:with-param>
    <xsl:with-param name="id">contents</xsl:with-param>
    <xsl:with-param name="section_depth" select="$section_depth"/>
    <xsl:with-param name="contents">
      <div>
        <ol type="{$list_type}">
          <!--
            Add a list item for each of the section elements that
            are siblings following this toc element
          -->
          <xsl:for-each select="following-sibling::section">
            <li class="toclink"><a href="#{@id}"><xsl:value-of select="@title"/></a></li>
          </xsl:for-each>
        </ol>
      </div>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="overview">
  <xsl:param name="section_depth" select="0"/>
  <xsl:call-template name="section">
    <xsl:with-param name="title">Overview</xsl:with-param>
    <xsl:with-param name="id">overview</xsl:with-param>
    <xsl:with-param name="section_depth" select="$section_depth"/>
    <xsl:with-param name="contents">
      <xsl:value-of select="$project_description"/>
      <xsl:apply-templates/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="copyright">
  All files provided with this application are<br/>
  <xsl:value-of select="$copyright"/>
</xsl:template>

<xsl:template match="infobox">
  <div class="infobox">
    <div class="infobox-heading">
      <a name="{@id}"><xsl:value-of select="@label"/></a>
    </div>
    <div class="infobox-content">
      <xsl:apply-templates/>
    </div>
  </div>
</xsl:template>

<xsl:template match="warnbox">
  <div class="warnbox">
    <div class="warnbox-heading">
      <a name="{@id}"><xsl:value-of select="@label"/></a>
    </div>
    <div class="warnbox-content">
      <xsl:apply-templates/>
    </div>
  </div>
</xsl:template>

<xsl:template match="filelist">
  <xsl:variable name="name" select="@name"/>
  <xsl:variable name="desc"><xsl:apply-templates select="desc"/></xsl:variable>
  <ul>
    <li>
      <xsl:if test="$name"><span class="file"><xsl:value-of select="@name"/></span></xsl:if>
      <xsl:if test="$desc"> - <xsl:copy-of select="$desc"/></xsl:if>
      <xsl:apply-templates select="filelist"/>
    </li>
  </ul>
</xsl:template>

<!-- link: A generic link -->
<!-- @dest: The URL to use as destination -->
<!-- @target: The target window/frame -->
<xsl:template match="link" name="link">
  <xsl:param name="dest" select="@dest"/>
  <xsl:param name="target" select="@target"/>

  <xsl:variable name="_target">
    <xsl:choose>
      <xsl:when test="$target"><xsl:value-of select="$target"/></xsl:when>
      <xsl:otherwise>_self</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <a href="{$dest}" target="{$_target}"><nobr><xsl:apply-templates/></nobr></a>
</xsl:template>

<!-- doclink: An in-document link -->
<!-- @dest: The name of the in-document element to link to -->
<xsl:template match="doclink" name="doclink">
  <xsl:param name="dest" select="@dest"/>
  <xsl:call-template name="link">
    <xsl:with-param name="dest"><xsl:value-of select="$doc_path"/>/<xsl:value-of select="$dest"/></xsl:with-param>
    <xsl:with-param name="target">_self</xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="map">
  <table class="map">
    <xsl:apply-templates/>
  </table>
</xsl:template>

<!-- Defer map/headings to the map/mapping template -->
<xsl:template match="map/headings">
  <tr class="mapheading">
    <xsl:apply-templates/>
  </tr>
</xsl:template>

<xsl:template match="map/mapping">
  <tr class="mapping">
    <xsl:apply-templates/>
  </tr>
</xsl:template>

<xsl:template match="headings/key">
  <th class="mapkey" valign="top"><xsl:apply-templates/></th>
</xsl:template>

<xsl:template match="headings/value">
  <th class="mapvalue" valign="top"><xsl:apply-templates/></th>
</xsl:template>

<xsl:template match="mapping/key">
  <td class="mapkey" valign="top"><xsl:apply-templates/></td>
</xsl:template>

<xsl:template match="mapping/value">
  <td class="mapvalue" valign="top"><xsl:apply-templates/></td>
</xsl:template>

<!-- term: A key term -->
<!-- @defurl: A URL where the term is defined -->
<xsl:template match="term">
  <span class="term">
    <!-- Make the term a link, if @defurl is specified -->
    <xsl:choose>
      <xsl:when test="count(@defurl) &gt; 0">
        <xsl:call-template name="link">
          <xsl:with-param name="dest" select="@defurl"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise><nobr><xsl:apply-templates/></nobr></xsl:otherwise>
    </xsl:choose>
  </span>
</xsl:template>

<!-- indent: Indent the contents -->
<xsl:template match="indent">
  <blockquote><xsl:apply-templates/></blockquote>
</xsl:template>

<!-- varcode: Variable code -->
<xsl:template match="varcode">
  <span class="varcode"><nobr><xsl:apply-templates/></nobr></span>
</xsl:template>

<!-- litcode: Literal code -->
<xsl:template match="litcode">
  <span class="litcode"><nobr><xsl:apply-templates/></nobr></span>
</xsl:template>

<!-- web_address: A web address; A URL -->
<xsl:template match="web_address">
  <span class="web_address"><nobr><xsl:apply-templates/></nobr></span>
</xsl:template>

<!-- litcode: Literal code -->
<xsl:template match="ant_target">
  <span class="ant_target"><nobr><xsl:apply-templates/></nobr></span>
</xsl:template>

<xsl:template match="ant_cmd">
  <xsl:text>the Ant </xsl:text>
  <span class="ant_target"><nobr><xsl:apply-templates/></nobr></span>
  <xsl:text> target</xsl:text>
</xsl:template>

<!-- litcode: Literal code -->
<xsl:template match="ant_property">
  <span class="ant_target"><nobr><xsl:apply-templates/></nobr></span>
</xsl:template>

<!-- file: A file or directory name -->
<xsl:template match="file">
  <span class="file"><nobr><xsl:apply-templates/></nobr></span>
</xsl:template>

<!-- ui_element: A User Interface element (e.g. a menu name, or a button) -->
<xsl:template match="ui_element">
  <span class="ui_element"><nobr><xsl:apply-templates/></nobr></span>
</xsl:template>


<!-- Copy any node not matching one of the templates above, and its attributes -->
<xsl:template match="node()|@*">
  <xsl:copy><xsl:apply-templates select="node()|@*"/></xsl:copy>
</xsl:template>

</xsl:stylesheet>
