package com.heckmansoft.surjey.view;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import com.heckmansoft.surjey.model.vo.Survey;

/**
 * Helper class for rendering a survey.
 * This is the Tag Handler class for a Tag Extension as defined
 * in the JSP Specification.
 * @see javax.servlet.jsp.tagext.TagSupport
 */
public class RenderSurveyTagHandler extends TagSupport {
    private String var;

    /**
     * @see javax.servlet.jsp.tagext.TagSupport#doStartTag()
     */
    public int doStartTag() throws JspException {
        Object obj = pageContext.findAttribute(var);

        if (obj == null) {
            throw new JspException(
                var + " not in context.");
        } else if (!(obj instanceof Survey)) {
            throw new JspException(
                "context attribute \"" + var + "\" is not a survey.");
        } else {
            pageContext.setAttribute("survey", obj);
            return EVAL_BODY_INCLUDE;
        }
    }

    /**
     * Get the value of var.
     */
    public String getVar() {
        return var;
    }

    /**
     * Set the value of var.
     */
    public void setVar(String var) {
        this.var = var;
    }
}
