package com.heckmansoft.surjey.model.vo.lazy;

import com.heckmansoft.surjey.model.datastore.DatastoreException;
import com.heckmansoft.surjey.model.manager.SurveyManager;
import com.heckmansoft.surjey.model.vo.Survey;
import com.heckmansoft.surjey.model.vo.list.ValueObjectList;

/**
 * A survey.
 * Contains a list of sections.
 */
public class LazySurvey extends Survey
{
    private SurveyManager manager;

    /**
     *
     */
    public LazySurvey(SurveyManager manager) {
        super();
        this.manager = manager;
    }

    public ValueObjectList getSections() {
        if (sectionsIsNull()) {
            if (manager == null) throw new RuntimeException("No manager defined.");
            try {
                setSections(manager.getSections(this.getId()));
            } catch (DatastoreException e) {
                throw new RuntimeException(e);
            }
        }
        return super.getSections();
    }

}
