package com.heckmansoft.surjey.model.vo.lazy;

import com.heckmansoft.surjey.model.datastore.DatastoreException;
import com.heckmansoft.surjey.model.manager.SectionManager;
import com.heckmansoft.surjey.model.vo.Section;
import com.heckmansoft.surjey.model.vo.list.ValueObjectList;

/**
 * A section that follows the lazy pattern.
 * Contains a list of questions.
 * Questions are automatically retrieved from the section manager
 * only when they are first accessed using getQuestions()
 */
public class LazySection extends Section
{
    private SectionManager manager;

    /**
     * Constructor
     * @param manager A section manager
     */
    public LazySection(SectionManager manager) {
        super();
        this.manager = manager;
    }

    /**
     *
     */
    public ValueObjectList getQuestions() {
        if (questionsIsNull()) {
            if (manager == null) throw new RuntimeException("No manager defined.");
            try {
                this.setQuestions(manager.getQuestions(this.getId()));
            } catch (DatastoreException e) {
                throw new RuntimeException(e);
            }
        }
        return super.getQuestions();
    }

}
