package com.heckmansoft.surjey.model.vo.lazy;

import com.heckmansoft.surjey.model.datastore.DatastoreException;
import com.heckmansoft.surjey.model.manager.ResponseManager;
import com.heckmansoft.surjey.model.vo.Response;
import com.heckmansoft.surjey.model.vo.list.ValueObjectList;

/**
 * A response that follows the lazy pattern.
 * Contains a list of answers.
 * Answers are automatically retrieved from the response manager
 * only when they are first accessed using getAnswers()
 */
public class LazyResponse extends Response
{
    private ResponseManager manager;

    /**
     * Constructor
     * @param manager A response manager
     */
    public LazyResponse(ResponseManager manager) {
        super();
        this.manager = manager;
    }

    /**
     *
     */
    public ValueObjectList getResponseAnswers() {
        if (hasNoAnswers()) {
            if (manager == null) throw new RuntimeException("No manager defined.");
            try {
                this.setResponseAnswers(manager.getResponseAnswers(this.getId()));
            } catch (DatastoreException e) {
                throw new RuntimeException(e);
            }
        }
        return super.getResponseAnswers();
    }

}
