package com.heckmansoft.surjey.model.vo.lazy;

import com.heckmansoft.surjey.model.datastore.DatastoreException;
import com.heckmansoft.surjey.model.manager.QuestionManager;
import com.heckmansoft.surjey.model.vo.Question;
import com.heckmansoft.surjey.model.vo.QuestionType;

/**
 * A question.
 * Contains a question type.
 */
public class LazyQuestion extends Question
{
    private QuestionManager manager;

    /**
     * Constructor.
     * @param manager A question manager
     */
    public LazyQuestion(QuestionManager manager) {
        super();
        this.manager = manager;
    }

    /**
     *
     */
    public QuestionType getQuestionType() {
        if (questionTypeIsNull()) {
            if (manager == null) throw new RuntimeException("No manager defined.");
            try {
                setQuestionType(manager.getQuestionType(this.getId()));
            } catch (DatastoreException e) {
                throw new RuntimeException(e);
            }
        }
        return super.getQuestionType();
    }

}