package com.heckmansoft.surjey.model.vo;

/**
 * A generic value object.
 */
public class ValueObject implements java.io.Serializable, Comparable
{
    String id;
    String name;

    // Constructors

    /**
     *
     */
    public ValueObject() {
        this.id = "0";
        this.name = "";
    }

    // Getters and setters

    /**
     *
     */
    public String getId() {
        return this.id;
    }

    /**
     *
     */
    public String getName() {
        return name;
    }

    /**
     *
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     *
     */
    public void setName(String string) {
        name = string;
    }

    // Utility methods

    /**
     *
     */
    public String toString() {
        return "[ValueObject: (" + id + ")]";
    }

    /**
     *
     */
    public boolean equals(Object other) {
        if (other == null) return false;
        if (!(other instanceof ValueObject)) return false;
        return (compareTo(other) == 0);
    }

    /**
     *
     */
    public int compareTo(Object other) {
        ValueObject vo = (ValueObject) other;

        int cmp;

        // Compare names, return result if different
        cmp = name.compareTo(vo.name);
        if (cmp != 0) return cmp;

        // Compare ids to ensure a total ordering
        cmp = id.compareTo(vo.id);
        if (cmp != 0) return cmp;

        return 0;
    }

    /**
     *
     */
    public int hashCode() {
        return this.id.hashCode();
    }

}
