package com.heckmansoft.surjey.model.vo;

import com.heckmansoft.surjey.model.vo.list.ValueObjectList;

/**
 * A survey.
 * Contains a list of sections.
 */
public class Survey extends ValueObject
{
    String description;
    ValueObjectList sections;

    /**
     *
     */
    public Survey() {
        super();
        this.description = "";
    }

    /**
     *
     */
    public String getDescription() {
        return description;
    }

    /**
     *
     */
    public void setDescription(String string) {
        description = string;
    }

    /**
     *
     */
    public ValueObjectList getSections() {
        return this.sections;
    }

    /**
     *
     */
    public void setSections(ValueObjectList sections) {
        this.sections = sections;
    }

    /**
     *
     */
    public boolean sectionsIsNull() {
        return (this.sections == null);
    }

    /**
     *
     */
    public boolean equals(Object other) {
        return (super.equals(other) && (other instanceof Survey));
    }

    /**
     *
     */
    public int compareTo(Object other) {
        Survey survey = (Survey) other;

        int cmp;

        // Compare descriptions, return result if different
        cmp = description.compareTo(survey.description);
        if (cmp != 0) return cmp;

        // Compare ids to ensure a total ordering
        return super.compareTo(survey);
    }

    /**
     *
     */
    public String toString() {
        return "[Survey: (" + id + ") " + name + ": " + description + "]";
    }

}
