package com.heckmansoft.surjey.model.vo;

import com.heckmansoft.surjey.model.vo.list.ValueObjectList;

/**
 * A section.
 * Contains a list of questions.
 */
public class Section extends ValueObject
{
    String description;
    String position;
    String surveyId;

    ValueObjectList questions;

    /**
     * Constructor.
     */
    public Section() {
        super();
        this.description = "";
        this.position = "0";
        this.surveyId = "0";
    }

    /**
     *
     */
    public String getDescription() {
        return description;
    }

    /**
     *
     */
    public void setDescription(String string) {
        description = string;
    }

    /**
     *
     */
    public String getPosition() {
        return position;
    }

    /**
     *
     */
    public String getSurveyId() {
        return surveyId;
    }

    /**
     *
     */
    public ValueObjectList getQuestions() {
        return questions;
    }

    /**
     *
     */
    public void setPosition(String string) {
        position = string;
    }

    /**
     *
     */
    public void setSurveyId(String string) {
        surveyId = string;
    }

    /**
     *
     */
    public void setQuestions(ValueObjectList list) {
        questions = list;
    }

    public boolean questionsIsNull() {
        return (this.questions == null);
    }

    public int compareTo(Object other) {
        Section section = (Section) other;

        int cmp;

        // Compare positions, return result if different
        cmp = position.compareTo(section.position);
        if (cmp != 0) return cmp;

        // Compare descriptions, return result if different
        cmp = description.compareTo(section.description);
        if (cmp != 0) return cmp;

        // Compare survey ids, return result if different
        cmp = surveyId.compareTo(section.surveyId);
        if (cmp != 0) return cmp;

        return super.compareTo(other);
    }

    /**
     *
     */
    public boolean equals(Object other) {
        return (super.equals(other) && (other instanceof Section));
    }

    public String toString() {
        return "[Section: (" + id + ")" + position + ": " + name + ": " + description + "]";
    }
}
