package com.heckmansoft.surjey.model.vo;

/**
 * An answer to a question in a response.
 */
public class ResponseAnswer extends ValueObject
{
    String responseId;
    String questionId;
    String answer;

    /**
     *
     */
    public ResponseAnswer() {
        this.responseId = "0";
        this.questionId = "0";
        this.answer = "";
    }

    public String getResponseId() {
        return this.responseId;
    }

    public String getQuestionId() {
        return this.questionId;
    }

    public String getAnswer() {
        return this.answer;
    }


    public void setResponseId(String responseId) {
        this.responseId = responseId;
    }

    public void setQuestionId(String questionId) {
        this.questionId = questionId;
    }

    public void setAnswer(String answer) {
        this.answer = answer;
    }


    public String toString() {
        return "[Answer: (" + id + ")" + responseId + ": " + questionId + ": " + answer + "]";
    }

    /**
     *
     */
    public boolean equals(Object other) {
        return (super.equals(other) && (other instanceof ResponseAnswer));
    }

    public int compareTo(Object other) {
        ResponseAnswer otherAnswer = (ResponseAnswer) other;

        int cmp;

        // Compare responseIds, return result if different
        cmp = responseId.compareTo(otherAnswer.responseId);
        if (cmp != 0) return cmp;

        // Compare questionIds, return result if different
        cmp = questionId.compareTo(otherAnswer.questionId);
        if (cmp != 0) return cmp;

        // Compare questionIds, return result if different
        cmp = answer.compareTo(otherAnswer.answer);
        if (cmp != 0) return cmp;

        return super.compareTo(other);
    }

}
