package com.heckmansoft.surjey.model.vo;

import com.heckmansoft.surjey.model.vo.list.ValueObjectList;


/**
 * A response.
 * Contains a list of answers.
 */
public class Response extends ValueObject
{
    String surveyId;
    String respondentAddress;
    ValueObjectList answers;

    public Response() {
        super();
        this.surveyId = "0";
        this.respondentAddress = "";
    }

    public String getSurveyId() {
        return surveyId;
    }

    public String getRespondentAddress() {
        return respondentAddress;
    }

    public ValueObjectList getResponseAnswers() {
        return answers;
    }

    public void setSurveyId(String surveyId) {
        this.surveyId = surveyId;
    }

    public void setRespondentAddress(String respondentAddress) {
        this.respondentAddress = respondentAddress;
    }

    public void setResponseAnswers(ValueObjectList answers) {
        this.answers = answers;
    }

    public boolean hasNoAnswers() {
        return (this.answers == null);
    }

    public String toString() {
        return "[Response: (" + id + ") (" + surveyId + ") (" + respondentAddress + ")]";
    }

    /**
     *
     */
    public boolean equals(Object other) {
        return (super.equals(other) && (other instanceof Response));
    }

    public int compareTo(Object other) {
        Response response = (Response) other;

        int cmp;

        // Compare surveyIds, return result if different
        cmp = surveyId.compareTo(response.surveyId);
        if (cmp != 0) return cmp;

        // Compare answers, return result if different
        cmp = respondentAddress.compareTo(response.respondentAddress);
        if (cmp != 0) return cmp;

        return super.compareTo(other);
    }

}
