package com.heckmansoft.surjey.model.vo;

/**
 * A question type.
 */
public class QuestionType extends ValueObject
{
    String description;

    /**
     *
     */
    public QuestionType() {
        super();
        this.description = "";
    }

    /**
     *
     */
    public String getDescription() {
        return description;
    }

    /**
     *
     */
    public void setDescription(String string) {
        description = string;
    }

    public String toString() {
        return "[QuestionType: (" + id + ")" + name + ": " + description + "]";
    }

    /**
     *
     */
    public boolean equals(Object other) {
        return (super.equals(other) && (other instanceof QuestionType));
    }

    /**
     *
     */
    public int compareTo(Object other) {
        QuestionType questionType = (QuestionType) other;

        int cmp;

        // Compare descriptions, return result if different
        cmp = description.compareTo(questionType.description);
        if (cmp != 0) return cmp;

        // Compare ids to ensure a total ordering
        return super.compareTo(questionType);
    }

}
