package com.heckmansoft.surjey.model.vo;

/**
 * A question.
 * Contains a question type.
 */
public class Question extends ValueObject
{
    String position;
    String label;
    String displaySize;
    String answerLabels;
    String sectionId;
    String questionTypeId;

    QuestionType questionType;

    /**
     *
     */
    public Question() {
        super();
        this.label = "";
        this.position = "0";
        this.sectionId = "0";
        this.questionTypeId = "0";
    }

    /**
     *
     */
    public String getPosition() {
        return position;
    }

    /**
     *
     */
    public String getLabel() {
        return label;
    }

    /**
     *
     */
    public String getDisplaySize() {
        return displaySize;
    }

    /**
     *
     */
    public String getAnswerLabels() {
        return answerLabels;
    }

    /**
     *
     */
    public QuestionType getQuestionType() {
        return questionType;
    }

    /**
     *
     */
    public String getSectionId() {
        return sectionId;
    }

    /**
     *
     */
    public String getQuestionTypeId() {
        return questionTypeId;
    }

    /**
     *
     */
    public void setLabel(String string) {
        label = string;
    }

    /**
     *
     */
    public void setPosition(String string) {
        position = string;
    }

    /**
     *
     */
    public void setDisplaySize(String string) {
        displaySize = string;
    }

    /**
     *
     */
    public void setAnswerLabels(String answers) {
        answerLabels = answers;
    }

    /**
     *
     */
    public void setSectionId(String string) {
        sectionId = string;
    }

    /**
     *
     */
    public void setQuestionTypeId(String string) {
        questionTypeId = string;
    }

    /**
     *
     */
    public void setQuestionType(QuestionType type) {
        questionType = type;
    }

    public boolean questionTypeIsNull() {
        return (this.questionType == null);
    }

    /**
     *
     */
    public boolean equals(Object other) {
        return (super.equals(other) && (other instanceof Question));
    }

    public int compareTo(Object other) {
        Question question = (Question) other;

        int cmp;

        // Compare positions, return result if different
        cmp = position.compareTo(question.position);
        if (cmp != 0) return cmp;

        // Compare question types, return result if different
        if (questionType != null && question.questionType != null) {
            cmp = questionType.compareTo(question.questionType);
            if (cmp != 0) return cmp;
        }

        // Compare labels, return result if different
        cmp = label.compareTo(question.label);
        if (cmp != 0) return cmp;

        // Compare answerLabels, return result if different
        if (answerLabels != null && question.answerLabels != null) {
            cmp = answerLabels.compareTo(question.answerLabels);
            if (cmp != 0) return cmp;
        }

        // Compare displaySize, return result if different
        if (displaySize != null && question.displaySize != null) {
            cmp = displaySize.compareTo(question.displaySize);
            if (cmp != 0) return cmp;
        }

        // Compare section ids, return result if different
        cmp = sectionId.compareTo(question.sectionId);
        if (cmp != 0) return cmp;

        return super.compareTo(other);
    }

    public String toString() {
        return "[Question: (" + id + ") " + position + ": " + label + " (" + questionTypeId + " : " + answerLabels + ") (section " + sectionId + ") (displaySize " + displaySize + ")]";
    }

}