package com.heckmansoft.surjey.model.manager;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Iterator;

import org.apache.log4j.Logger;

import com.heckmansoft.surjey.model.datastore.DatastoreException;
import com.heckmansoft.surjey.model.datastore.QuestionDatastore;
import com.heckmansoft.surjey.model.datastore.QuestionTypeDatastore;
import com.heckmansoft.surjey.model.vo.Question;
import com.heckmansoft.surjey.model.vo.QuestionType;
import com.heckmansoft.surjey.model.vo.lazy.LazyQuestion;
import com.heckmansoft.surjey.model.vo.list.ValueObjectList;

/**
 * Manages Question objects
 */
public class QuestionManager extends QuestionDatastore
{
    QuestionTypeDatastore questionTypeDatastore;
    HashMap questionTypesMap;
    ValueObjectList questionTypes;

    private Logger log = Logger.getLogger(QuestionManager.class);

    /**
     * Constructor.
     */
    public QuestionManager() {
        super();
        questionTypeDatastore = new QuestionTypeDatastore();

        // Initialize both a list and a map of question types
        questionTypesMap = new HashMap();
        try {
            questionTypes = questionTypeDatastore.findAll();
            Iterator i = questionTypes.iterator();
            while (i.hasNext()) {
                QuestionType type = (QuestionType) i.next();
                questionTypesMap.put(type.getId(),type);
            }
        } catch (DatastoreException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Get a question type
     * @param id The question id.
     * @return The Question type instance
     */
    public QuestionType getQuestionType(String id) throws DatastoreException {
        Question q = findById(id);
        return (QuestionType) questionTypesMap.get(q.getQuestionTypeId());
    }

    /**
     * Get an iterator over the question types.
     * @return An iterator over the list of QuestionTypes.
     */
    public Iterator getTypesIterator() throws DatastoreException {
        return questionTypes.iterator();
    }

    /**
     * Get all the question types.
     * @return A list of QuestionTypes
     */
    public ValueObjectList findAllTypes() throws DatastoreException {
        return questionTypes;
    }

    /**
     * Create a new question.
     * @return newly created question.
     */
    public Question createQuestion() {
        return new LazyQuestion(this);
    }

    /**
     * Create a new question for a given section.
     * @param sectionId Id of section for new question.
     * @return newly created question.
     */
    public Question createQuestion(String sectionId) throws DatastoreException {
        Question question = createQuestion();
        question.setPosition(getNextPosition(sectionId));
        question.setSectionId(sectionId);
        return question;
    }

    /**
     * Lookup position of next question
     */
    protected String getNextPosition(String sectionId) throws DatastoreException {
        int nextPosition = 1;
        List questions = findBySectionId(sectionId);
        int size = questions.size();
        if (size > 0) {
            Question lastQuestion = (Question) questions.get(size-1);
            nextPosition = 1 + Integer.parseInt(lastQuestion.getPosition());
        }

        return String.valueOf(nextPosition);
    }
}
