package com.heckmansoft.surjey.model.datastore;

import java.sql.SQLException;

/**
 * Exception thrown by a Datastore when access/update of data store causes
 * an exception.
 * Wraps the relevant exception.
 */
public class DatastoreException extends Exception {

    /**
     * Constructor.
     * @param cause The cause of the exception.
     */
    public DatastoreException(SQLException cause) {
        super(cause.getMessage() + " (" + cause.getSQLState() + ")",cause);
    }

    /**
     * Constructor.
     * @param cause The cause of the exception.
     */
    public DatastoreException(Throwable cause) {
        super(cause);
    }

    /**
     * Constructor.
     * @param message The message to use in the exception
     */
    public DatastoreException(String message) {
        super(message);
    }

}
