package com.heckmansoft.surjey.filter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import javax.servlet.ServletOutputStream;

/**
 * Implementation of a ServletOutputStream for filters.
 *
 * The ServletOutputStream cannot be modified after a
 * resource has committed it, so we provide our own implementation.
 * @see javax.servlet.ServletOutputStream
 */
public class FilterServletOutputStream extends ServletOutputStream
{
    private DataOutputStream stream;

    public FilterServletOutputStream(OutputStream output) {
        stream = new DataOutputStream(output);
    }

    public void write(int b) throws IOException {
        stream.write(b);
    }

    public void write(byte[] b) throws IOException {
        stream.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        stream.write(b, off, len);
    }
}
