package com.heckmansoft.surjey.filter;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

import org.apache.log4j.Logger;

/**
 * A wrapper around the response used for filtering.
 *
 * @see javax.servlet.http.HttpServletResponse
 * @see javax.servlet.http.HttpServletResponseWrapper
 */
public class FilterResponseWrapper extends HttpServletResponseWrapper
{
    private StringWriter output;
    private int contentLength;
    private String contentType;

    Logger log = Logger.getLogger(FilterResponseWrapper.class);

    /**
     * Constructor.
     * @param response The response to wrap.
     */
    public FilterResponseWrapper(HttpServletResponse response) {
        super(response);
        output = new StringWriter();
        this.contentLength = 0;
    }

    /**
     * Convert substitute response to string.
     */
    public String toString() {
        return output.toString();
    }

    /**
     * Get a PrintWriter for substitute response.
     * @see javax.servlet.ServletResponse#getWriter()
     */
    public PrintWriter getWriter() {
        return new PrintWriter(output,true);
    }

    /**
     * Close the substitute response.
     * @throws IOException
     */
    public void close() throws IOException {
        output.close();
    }

    /**
     * Set the content length of the substitute response.
     * @see javax.servlet.http.HttpServletResponse#setContentLength(int)
     */
    public void setContentLength(int length) {
        this.contentLength = length;
        //super.setContentLength(length);
    }

    /**
     * Set the content type of the substitute response.
     * @see javax.servlet.http.HttpServletResponse#setContentType(java.lang.String)
     */
    public void setContentType(String type) {
        this.contentType = type;
        //super.setContentType(type);
    }

    /**
     * Flush the buffer of the substitute response.
     * @see javax.servlet.http.HttpServletResponse#flushBuffer()
     * @throws IOException
     */
    public void flushBuffer() throws IOException {
        output.flush();
    }

}
