package com.heckmansoft.surjey.controller.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

import com.heckmansoft.surjey.model.vo.Survey;

/**
 * Action to enable updating a survey.
 */
public class UpdateSurveyAction extends SurveyAction {

    Logger log = Logger.getLogger(UpdateSurveyAction.class);

    public UpdateSurveyAction(Object source) {
        super(source);
    }

    /**
     * @see com.heckmansoft.surjey.controller.action.Action#execute(HttpServletRequest, HttpServletResponse)
     */
    public String execute(
        HttpServletRequest request,
        HttpServletResponse response)
    throws Exception {
        log.debug("execute()");

        // Get the survey from the request
        Survey survey = parseRequest(request);

        // Perform the update
        surveyManager.update(survey);

        // Set the edit mode
        request.setAttribute("mode","Edit");

        // Store the survey in the request
        request.setAttribute("survey", survey);

        // Forward to view
        return "EditSurvey";
    }

}
