package com.heckmansoft.surjey.controller.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

import com.heckmansoft.surjey.model.vo.Section;

/**
 * Action to enable updating a section.
 */
public class UpdateSectionAction extends SectionAction {

    Logger log = Logger.getLogger(UpdateSectionAction.class);

    public UpdateSectionAction(Object source) {
        super(source);
    }

    /**
     * @see com.heckmansoft.surjey.controller.action.Action#execute(HttpServletRequest, HttpServletResponse)
     */
    public String execute(
        HttpServletRequest request,
        HttpServletResponse response)
    throws Exception {
        log.debug("execute()");

        // Get the section from the request
        Section section = parseRequest(request);

        // Perform the update
        sectionManager.update(section);

        // Set the edit mode
        request.setAttribute("mode","Edit");

        // Store the section in the request
        request.setAttribute("section", section);

        // Forward to view
        return "EditSection";
    }

}
