package com.heckmansoft.surjey.controller.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

import com.heckmansoft.surjey.model.vo.Question;

/**
 * Action to enable updating a question.
 */
public class UpdateQuestionAction extends QuestionAction {

    Logger log = Logger.getLogger(UpdateQuestionAction.class);

    public UpdateQuestionAction(Object source) {
        super(source);
    }

    /**
     * @see com.heckmansoft.surjey.controller.action.Action#execute(HttpServletRequest, HttpServletResponse)
     */
    public String execute(
        HttpServletRequest request,
        HttpServletResponse response)
    throws Exception {
        log.debug("execute()");

        // Get the question from the request
        Question question = parseRequest(request);

        // Perform the update
        questionManager.update(question);

        // Set the edit mode
        request.setAttribute("mode","Edit");

        // Store the question in the request
        request.setAttribute("question", question);

        // Lookup the question types and store in the request
        request.setAttribute("types", questionManager.getTypesIterator());

        // Forward to view
        return "EditQuestion";
    }

}
