package com.heckmansoft.surjey.controller.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

import com.heckmansoft.surjey.model.vo.Survey;

/**
 * Action to enable taking a survey.
 * Builds complete survey from managers and prepares it for
 * rendering.
 */
public class TakeSurveyAction extends SurveyAction {

    Logger log = Logger.getLogger(TakeSurveyAction.class);

    public TakeSurveyAction(Object source) {
        super(source);
    }

    /**
     * @see com.heckmansoft.surjey.controller.action.Action#execute(HttpServletRequest, HttpServletResponse)
     */
    public String execute(
        HttpServletRequest request,
        HttpServletResponse response)
    throws Exception {
        log.debug("execute()");

        // Get the survey id from the request
        String id = (String) request.getParameter("surveyId");

        // Get the survey
        Survey survey = surveyManager.findById(id);

        // Store survey in request
        request.setAttribute("survey", survey);

        // Forward to view
        return "RenderSurvey";
    }

}
