package com.heckmansoft.surjey.controller.action;

import javax.servlet.http.HttpServletRequest;

import com.heckmansoft.surjey.model.vo.*;

/**
 * Abstract superclass for all Survey actions.
 */
public abstract class SurveyAction extends Action
{
    /**
     * Constructor.
     * @param source The source creating this action.
     */
    public SurveyAction(Object source) {
        super(source);
    }

    /**
     * Parse a request for a new survey
     */
    public Survey parseRequest(HttpServletRequest request)
    {
        Survey survey = surveyManager.createSurvey();
        survey.setId((String) request.getParameter("surveyId"));
        survey.setName((String) request.getParameter("name"));
        survey.setDescription((String) request.getParameter("description"));

        return survey;
    }

}
