package com.heckmansoft.surjey.controller.action;

import javax.servlet.http.HttpServletRequest;

import com.heckmansoft.surjey.model.vo.*;

/**
 * Abstract superclass for all Section actions.
 */
public abstract class SectionAction extends Action
{
    /**
     * Constructor.
     * @param source The source creating this action.
     */
    public SectionAction(Object source) {
        super(source);
    }

    /**
     * Parse a request for a new section
     */
    public Section parseRequest(HttpServletRequest request)
    {
        // Get the section from the request
        Section section = sectionManager.createSection();
        section.setId((String) request.getParameter("sectionId"));
        section.setPosition((String) request.getParameter("position"));
        section.setName((String) request.getParameter("name"));
        section.setDescription((String) request.getParameter("description"));
        section.setSurveyId((String) request.getParameter("surveyId"));

        return section;
    }

}
