package com.heckmansoft.surjey.controller.action;

import javax.servlet.http.HttpServletRequest;

import com.heckmansoft.surjey.model.vo.*;

/**
 * Abstract superclass for all Question actions.
 */
public abstract class QuestionAction extends Action
{
    /**
     * Constructor.
     * @param source The source creating this action.
     */
    public QuestionAction(Object source) {
        super(source);
    }

    /**
     * Parse a request for a new question.
     */
    public Question parseRequest(HttpServletRequest request)
    {
        Question question = questionManager.createQuestion();
        question.setId((String) request.getParameter("questionId"));
        question.setName((String) request.getParameter("name"));
        question.setPosition((String) request.getParameter("position"));
        question.setLabel((String) request.getParameter("label"));
        question.setDisplaySize((String) request.getParameter("displaySize"));
        question.setSectionId((String) request.getParameter("sectionId"));
        question.setQuestionTypeId((String) request.getParameter("questionTypeId"));
        question.setAnswerLabels((String) request.getParameter("answerLabels"));

        return question;
    }

}
