package com.heckmansoft.surjey.controller.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

/**
 * Action to enable editing a survey.
 */
public class EditSurveyAction extends SurveyAction {

    Logger log = Logger.getLogger(EditSurveyAction.class);

    public EditSurveyAction(Object source) {
        super(source);
    }

    /**
     * @see com.heckmansoft.surjey.controller.action.Action#execute(HttpServletRequest, HttpServletResponse)
     */
    public String execute(
        HttpServletRequest request,
        HttpServletResponse response)
    throws Exception {
        log.debug("execute()");

        // Get the survey id from the request
        String id = (String) request.getParameter("surveyId");

        // Lookup the survey and store in the request
        request.setAttribute("survey", surveyManager.findById(id));

        request.setAttribute("mode","Edit");

        // Forward to view
        return "EditSurvey";
    }

}
