package com.heckmansoft.surjey.controller.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

/**
 * Action to enable editing a section.
 */
public class EditSectionAction extends SectionAction {

    Logger log = Logger.getLogger(EditSectionAction.class);

    public EditSectionAction(Object source) {
        super(source);
    }

    /**
     * @see com.heckmansoft.surjey.controller.action.Action#execute(HttpServletRequest, HttpServletResponse)
     */
    public String execute(
        HttpServletRequest request,
        HttpServletResponse response)
    throws Exception {
        log.debug("execute()");

        // Get the section id
        String id = (String) request.getParameter("sectionId");

        // Lookup the section and store in the request
        request.setAttribute("section", sectionManager.findById(id));

        request.setAttribute("mode","Edit");

        // Forward to view
        return "EditSection";
    }

}
