package com.heckmansoft.surjey.controller.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

/**
 * Action to enable editing a question.
 */
public class EditQuestionAction extends QuestionAction {

    Logger log = Logger.getLogger(EditQuestionAction.class);

    public EditQuestionAction(Object source) {
        super(source);
    }

    /**
     * @see com.heckmansoft.surjey.controller.action.Action#execute(HttpServletRequest, HttpServletResponse)
     */
    public String execute(
        HttpServletRequest request,
        HttpServletResponse response)
    throws Exception {
        log.debug("execute()");

        // Get the question id
        String id = (String) request.getParameter("questionId");

        // Lookup the question and store in the request
        request.setAttribute("question", questionManager.findById(id));

        // Lookup the question types and store in the request
        request.setAttribute("types", questionManager.getTypesIterator());

        request.setAttribute("mode","Edit");

        // Forward to view
        return "EditQuestion";
    }

}
