package com.heckmansoft.surjey.controller.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

/**
 * Action to enable deleting a section.
 */
public class DeleteSectionAction extends SectionAction {

    Logger log = Logger.getLogger(DeleteSectionAction.class);

    public DeleteSectionAction(Object source) {
        super(source);
    }

    /**
     * @see com.heckmansoft.surjey.controller.action.Action#execute(HttpServletRequest, HttpServletResponse)
     */
    public String execute(
        HttpServletRequest request,
        HttpServletResponse response)
    throws Exception {
        log.debug("execute()");

        // Get the section id from the request
        String id = (String) request.getParameter("sectionId");

        // Delete section
        sectionManager.remove(id);

        Action forward = new EditSurveyAction(this.source);
        return forward.execute(request,response);
    }

}
