package com.heckmansoft.surjey.controller.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

import com.heckmansoft.surjey.model.vo.Survey;

/**
 * Action to enable creating a new survey.
 */
public class CreateSurveyAction extends SurveyAction {

    Logger log = Logger.getLogger(CreateSurveyAction.class);

    public CreateSurveyAction(Object source) {
        super(source);
    }

    /**
     * @see com.heckmansoft.surjey.controller.action.Action#execute(HttpServletRequest, HttpServletResponse)
     */
    public String execute(
        HttpServletRequest request,
        HttpServletResponse response)
    throws Exception {
        log.debug("execute()");

        // Get the survey from the request
        Survey survey = parseRequest(request);

        // Create the survey
        surveyManager.insert(survey);

        // Store the survey in the request
        request.setAttribute("survey", survey);

        request.setAttribute("mode","Edit");

        // Forward to view
        return "EditSurvey";
    }

}
