package com.heckmansoft.surjey.controller.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

import com.heckmansoft.surjey.model.vo.Section;

/**
 * Action to enable creating a new section.
 */
public class CreateSectionAction extends SectionAction {

    Logger log = Logger.getLogger(CreateSectionAction.class);

    public CreateSectionAction(Object source) {
        super(source);
    }

    /**
     * @see com.heckmansoft.surjey.controller.action.Action#execute(HttpServletRequest, HttpServletResponse)
     */
    public String execute(
        HttpServletRequest request,
        HttpServletResponse response)
    throws Exception {
        log.debug("execute()");

        // Get the survey id from the request
        String surveyId = (String) request.getParameter("surveyId");

        // Get the section from the request
        Section section = parseRequest(request);

        // Attempt to create the section from the request
        sectionManager.insert(section);

        // Store the survey in the request
        request.setAttribute("section", section);

        request.setAttribute("mode","Edit");

        // Forward to view
        return "EditSection";
    }

}
