package com.heckmansoft.surjey.controller.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

import com.heckmansoft.surjey.model.vo.Question;

/**
 * Action to enable creating a new question.
 */
public class CreateQuestionAction extends QuestionAction {

    Logger log = Logger.getLogger(CreateQuestionAction.class);

    public CreateQuestionAction(Object source) {
        super(source);
    }

    /**
     * @see com.heckmansoft.surjey.controller.action.Action#execute(HttpServletRequest, HttpServletResponse)
     */
    public String execute(
        HttpServletRequest request,
        HttpServletResponse response)
    throws Exception {
        log.debug("execute()");

        // Get the section id from the request
        String sectionId = (String) request.getParameter("sectionId");

        // Get the question from the request
        Question question = parseRequest(request);

        // Create the question
        questionManager.insert(question);

        // Store the question in the request
        request.setAttribute("question", question);

        request.setAttribute("mode","Edit");

        // Lookup the question types and store in the request
        request.setAttribute("types", questionManager.getTypesIterator());

        // Forward to view
        return "EditQuestion";
    }

}
