package com.heckmansoft.surjey.controller.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

/**
 * Action to enable displaying the Welcome page.
 * Get list of surveys in preparation for ChooseSurvey view.
 */
public class ChooseSurveyAction extends SurveyAction {

    Logger log = Logger.getLogger(WelcomeAction.class);

    public ChooseSurveyAction(Object source) {
        super(source);
    }

    /**
     * @see com.heckmansoft.surjey.controller.action.Action#execute(HttpServletRequest, HttpServletResponse)
     */
    public String execute(
        HttpServletRequest request,
        HttpServletResponse response)
    throws Exception {
        log.debug("execute()");

        // Get a list of all surveys and store in the request
        request.setAttribute("surveys", surveyManager.findAll());

        // Forward to view
        return "ChooseSurvey";
    }

}
