package com.heckmansoft.surjey.controller.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

import com.heckmansoft.surjey.model.vo.Section;

/**
 * Action to enable adding a new section.
 */
public class AddSectionAction extends SectionAction {

    Logger log = Logger.getLogger(AddSectionAction.class);

    public AddSectionAction(Object source) {
        super(source);
    }

    /**
     * @see com.heckmansoft.surjey.controller.action.Action#execute(HttpServletRequest, HttpServletResponse)
     */
    public String execute(
        HttpServletRequest request,
        HttpServletResponse response)
    throws Exception {
        log.debug("execute()");

        // Get survey id
        String surveyId = (String) request.getParameter("surveyId");

        // Create a new empty section and store in request
        request.setAttribute("section", sectionManager.createSection(surveyId));

        request.setAttribute("mode","Create");

        // Forward to view
        return "EditSection";
    }

}
