package com.heckmansoft.surjey.controller.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

import com.heckmansoft.surjey.model.vo.Question;

/**
 * Action to enable adding a new question.
 */
public class AddQuestionAction extends QuestionAction {

    Logger log = Logger.getLogger(AddQuestionAction.class);

    public AddQuestionAction(Object source) {
        super(source);
    }

    /**
     * @see com.heckmansoft.surjey.controller.action.Action#execute(HttpServletRequest, HttpServletResponse)
     */
    public String execute(
        HttpServletRequest request,
        HttpServletResponse response)
    throws Exception {
        log.debug("execute()");

        // Get section id
        String sectionId = (String) request.getParameter("sectionId");

        // Create a new empty question and store in request
        request.setAttribute("question", questionManager.createQuestion(sectionId));

        // Lookup list of question types and store in request
        request.setAttribute("types", questionManager.getTypesIterator());

        request.setAttribute("mode","Create");

        // Forward to view
        return "EditQuestion";
    }

}
