package com.heckmansoft.surjey.controller.action;

import java.util.EventObject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.heckmansoft.surjey.model.manager.SurveyManager;
import com.heckmansoft.surjey.model.manager.SectionManager;
import com.heckmansoft.surjey.model.manager.QuestionManager;

/**
 * Abstract superclass for all surjey actions.
 */
public abstract class Action extends EventObject
{
    protected SurveyManager surveyManager;
    protected QuestionManager questionManager;
    protected SectionManager sectionManager;

    /**
     * Constructor.
     * @param source The source creating this action.
     */
    public Action(Object source) {
        super(source);
        questionManager = new QuestionManager();
        sectionManager = new SectionManager();
        surveyManager = new SurveyManager();
    }

    /**
     * Takes a request and response, performs action,
     * and returns the next view.
     */
    public abstract String execute(
        HttpServletRequest request,
        HttpServletResponse response) throws Exception;
}
